package com.agilex.healthcare.veteranappointment.datalayer;

import javax.persistence.EntityManager;

import com.agilex.healthcare.veteranappointment.datalayer.appointment.AppointmentRequestPo;

@SuppressWarnings("unchecked")
public class validPo<T extends PersistenceObject> {
	private boolean ok = true;
	private T po = null;

	public validPo(EntityManager entityManager, T obj) {
		if (isNewRecord(obj)) {
			po = null;
			ok = true;
		} else {
			po = (T) entityManager.find(obj.getClass(), obj.getId());
			ok = computeOk(po, obj);
		}
	}

	public boolean isOk() {
		return ok;
	}

	public T getPo() {
		return po;
	}

	private boolean computeOk(T po, T obj) {
		try {
			if (po instanceof AppointmentRequestPo) {
				return true;
			}
			return po.getUserId().equalsIgnoreCase(obj.getUserId());
		} catch (NullPointerException e) {
			return true;
		}
	}

	private boolean isNewRecord(T obj) {
		return obj.getId() == null;
	}
}